﻿//////////////////////////////////////////////
// ContentLoadResult.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class BlendState ;
	class Buffer ;
	class Camera ;
	class Compositor ;
	class CompositorNode ;
	class ConstantBuffer ;
	class DepthStencilState ;
	class Mesh ;
	class Node ;
	class Pass ;
	class Program ;
	class RasterState ;
	class RenderQueue ;
	class Sampler ;
	class Shader ;
	class ShaderMemorySlot ;
	class Texture ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkGraphics
{
	enum class CONTENT_LOAD_RESULT_STATE
	{
		SUCCESS = 0,
		PARTIAL,
		FAILURE
	} ;

	template<typename T>
	class ContentLoadResult
	{
		public :

			// Attributs
			nkMemory::BufferCast<nkMemory::String> _errorMessages ;
			nkMemory::BufferCast<T*> _loadResult ;
			CONTENT_LOAD_RESULT_STATE _success = CONTENT_LOAD_RESULT_STATE::SUCCESS ;
	} ;

	typedef ContentLoadResult<Sampler> ContentLoadResultSampler ;
	typedef ContentLoadResult<Texture> ContentLoadResultTexture ;

	typedef ContentLoadResult<Buffer> ContentLoadResultBuffer ;
	typedef ContentLoadResult<ConstantBuffer> ContentLoadResultConstantBuffer ;
	typedef ContentLoadResult<Shader> ContentLoadResultShader ;
	typedef ContentLoadResult<ShaderMemorySlot> ContentLoadResultShaderMemorySlot ;
	typedef ContentLoadResult<Program> ContentLoadResultProgram ;

	typedef ContentLoadResult<Pass> ContentLoadResultPass ;
	typedef ContentLoadResult<Compositor> ContentLoadResultCompositor ;
	typedef ContentLoadResult<CompositorNode> ContentLoadResultCompositorNode ;

	typedef ContentLoadResult<Mesh> ContentLoadResultMesh ;
	typedef ContentLoadResult<Node> ContentLoadResultNode ;

	typedef ContentLoadResult<BlendState> ContentLoadResultBlendState ;
	typedef ContentLoadResult<DepthStencilState> ContentLoadResultDepthStencilState ;
	typedef ContentLoadResult<RasterState> ContentLoadResultRasterState ;

	using ContentLoadResultCamera = ContentLoadResult<Camera> ;
	using ContentLoadResultRenderQueue = ContentLoadResult<RenderQueue> ;
}